package jme.test.texture;

import ga.view.processor.OffscreenProcessor;

import com.jme3.app.SimpleApplication;
import com.jme3.light.PointLight;
import com.jme3.material.Material;
import com.jme3.math.ColorRGBA;
import com.jme3.math.Vector3f;
import com.jme3.renderer.queue.RenderQueue.ShadowMode;
import com.jme3.scene.Geometry;
import com.jme3.scene.Node;
import com.jme3.scene.Spatial;
import com.jme3.scene.shape.Box;

public class TestOffscreenRendering extends SimpleApplication {
  private Spatial teapot;
  private Geometry box;

  private OffscreenProcessor processor;

  private Node offScreenScene;

  public static void main(final String[] args) {
    final TestOffscreenRendering app = new TestOffscreenRendering();
    app.start();
  }

  @Override
  public void simpleInitApp() {
    cam.setLocation(new Vector3f(0, 1, 3));
    cam.lookAt(Vector3f.ZERO, Vector3f.UNIT_Y);

    // init the teapot and the teapot material
    final Material teapotMat = new Material(assetManager,
        "Common/MatDefs/Light/Lighting.j3md");
    teapotMat.setFloat("Shininess", 0.1f);
    teapotMat.setBoolean("UseMaterialColors", true);
    teapotMat.setColor("Ambient", ColorRGBA.Black);
    teapotMat.setColor("Diffuse", ColorRGBA.Red);
    teapotMat.setColor("Specular", ColorRGBA.Gray);
    teapotMat.setReceivesShadows(true);

    teapot = assetManager.loadModel("Models/Teapot/Teapot.obj");
    teapot.setLocalTranslation(0f, 0f, 0f);
    teapot.setMaterial(teapotMat);
    teapot.setShadowMode(ShadowMode.CastAndReceive);

    // init offscreen scene
    offScreenScene = new Node();
    offScreenScene.attachChild(teapot);
    PointLight l = new PointLight();
    l.setPosition(new Vector3f(5, 5, 5));
    offScreenScene.addLight(l);

    final Material offscreenMat = new Material(assetManager,
        "Common/MatDefs/Light/Lighting.j3md");
    offscreenMat.setFloat("Shininess", 1.0f);
    offscreenMat.setBoolean("UseMaterialColors", true);
    offscreenMat.setColor("Ambient", ColorRGBA.Black);
    offscreenMat.setColor("Diffuse", ColorRGBA.White);
    offscreenMat.setColor("Specular", ColorRGBA.Gray);
    offscreenMat.setReceivesShadows(true);

    // init the processor with the material. it will render to DiffuseMap
    processor = new OffscreenProcessor(assetManager, settings, offScreenScene,
        offscreenMat, "DiffuseMap");

    processor.getCamera().setLocation(new Vector3f(0f, .2f, 2f));
    processor.getCamera().lookAt(new Vector3f(0f, .4f, 0f), Vector3f.UNIT_Y);
    viewPort.addProcessor(processor);

    // init the box to render to
    box = new Geometry("box", new Box(new Vector3f(0f, 0f, 0f), .5f, .5f, .5f));
    box.setMaterial(offscreenMat);
    box.setShadowMode(ShadowMode.CastAndReceive);
    rootNode.attachChild(box);

    l = new PointLight();
    l.setPosition(new Vector3f(5, 5, 15));
    rootNode.addLight(l);
  }

  @Override
  public void simpleUpdate(final float tpf) {
    box.rotate(0, tpf, 0);

    teapot.rotate(0, tpf * -.5f, 0);
    offScreenScene.updateGeometricState();
  }
}
